#define _CRT_SECURE_NO_WARNINGS
#include <bits/stdc++.h>

using namespace std;

class Jarbol
{
private:

    long long int x;
    long long int y;
    long long int i;

public:

    long long int getX() const { return x; }
    void setX(long long int x) { this->x = x; }
    long long int getY() const { return y; }
    void setY(long long int y) { this->y = y; }
    long long int getI() const { return i; }
    void setI(long long int i) { this->i = i; }

    long long int PresekDesno(long long int y) { return this->x + this->y - y; }
    long long int PresekLevo(long long int y) { return this->x - this->y + y; }

    static long long int NajbliziVisiLevo(vector <Jarbol>& jarboli, unordered_map <long long int, long long int>& ivice, long long int duzina, long long int indeks)
    {
        Jarbol pocetni = jarboli[indeks];
        if (!ivice.count(indeks)) return -1;
        Jarbol krajnji = jarboli[ivice[indeks]];
        return pocetni.getX() - krajnji.PresekDesno(pocetni.getY());
    }

    static long long int NajbliziVisiDesno(vector <Jarbol>& jarboli, unordered_map <long long int, long long int>& ivice, long long int duzina, long long int indeks)
    {
        Jarbol pocetni = jarboli[indeks];
        if (!ivice.count(indeks)) return -1;
        Jarbol krajnji = jarboli[ivice[indeks]];
        return krajnji.PresekLevo(pocetni.getY()) - pocetni.getX();

    }
};

int main()
{
    long long int n;
    long long int pom;
    

    scanf("%d", &n);

    vector <Jarbol> jarboli(n);

    for (long long int i = 0; i < n; i++)
    {
        scanf("%d", &pom);
        jarboli[i].setX(pom);
        jarboli[i].setI(i);
    }

    for (long long int i = 0; i < n; i++)
    {
        scanf("%d", &pom);
        jarboli[i].setY(pom);
    }

    sort(jarboli.begin(), jarboli.end(),
        [](const Jarbol& t1, const Jarbol& t2) { 
            return t1.getX() < t2.getX(); 
        });

    unordered_map <long long int, long long int> iviceNadesno;

    long long int tekuci = 0;

    for (long long int i = 0; i < n - 1; i++)
    {
        long long int tekuci = i;
        long long int j = i+1;

        while (j < n)
        {
            if (iviceNadesno.count(tekuci)) break;

            if (jarboli[j].getY() >= jarboli[tekuci].getY())
            {
                iviceNadesno[tekuci] = j;
                tekuci = j;
            }
            j++;
        }
    }

    unordered_map <long long int, long long int > iviceNalevo;

    for (long long int i = n-1; i > 0; i--)
    {
        long long int tekuci = i;
        long long int j = i-1;

        while (j > -1)
        {
            if (iviceNalevo.count(tekuci)) break;

            if (jarboli[j].getY() >= jarboli[tekuci].getY())
            {
                iviceNalevo[tekuci] = j;
                tekuci = j;
            }
            j--;
        }
    }

    vector <long long int> output(n);

    long long int najbliziVisiDesno = 0, najbliziVisiLevo = 0;

    for (long long int i = 0; i < n; i++)
    {
        najbliziVisiDesno = Jarbol::NajbliziVisiDesno(jarboli, iviceNadesno, n, i);
        najbliziVisiLevo = Jarbol::NajbliziVisiLevo(jarboli, iviceNalevo, n, i);

        if (najbliziVisiDesno == -1 && najbliziVisiLevo == -1)
            output[jarboli[i].getI()] = -1;
        else if (najbliziVisiDesno == -1)
            output[jarboli[i].getI()] = (najbliziVisiLevo);
        else if (najbliziVisiLevo == -1)
            output[jarboli[i].getI()] = (najbliziVisiDesno);
        else
            output[jarboli[i].getI()] = (najbliziVisiDesno < najbliziVisiLevo ? najbliziVisiDesno : najbliziVisiLevo);
    }

    for (long long int i = 0; i < n; i++) printf("%d\n", output[i]);

    return 0;
}